# LiveChat PHP – Full Bundle (SSE)
All-in-one package combining starter + advanced features.

## Setup
1. Create a MySQL database and user.
2. Import `sql/schema.sql`.
3. Edit `config.php` (`DB_*`, `APP_URL`, `APP_SECRET`).
4. Upload all files to your hosting (keep folder structure).
5. Visit `/public/index.html` to try the Agent Console and see the embed snippet.

## Widget
```html
<script src="https://YOUR_DOMAIN/public/widget.js"></script>
<script>
  window.LiveChatConfig = { appUrl: 'https://YOUR_DOMAIN', siteKey: 'mysite.com', color: '#4f46e5' };
</script>
```

## Admin API (JWT)
- `POST /api/register.php` (bootstrap one admin/agent)
- `POST /api/login.php` → `{ token, user }` (send as `Authorization: Bearer <token>`)

## Core API
- `POST /api/start.php`
- `POST /api/send.php`
- `GET  /api/sse.php?conversation_id=&last_id=`
- `GET  /api/history.php?conversation_id=`
- `GET  /api/conversations.php`
- `POST /api/assign.php`
- `POST /api/upload.php` (multipart) → `{ url }`

## Advanced
- Ratings: `POST /api/rate.php`
- Close: `POST /api/close.php` (JWT)
- Presence: `POST /api/presence.php`, `GET /api/presence_get.php?conversation_id=`
- Analytics: `GET /api/analytics.php` (JWT)
- GDPR: `GET /api/export_conversation.php`, `POST /api/delete_conversation.php` (JWT admin)
- Webhooks: `lib + api/webhooks_fire.php`
- Web Push: `public/sw.js`, `POST /api/push_subscribe.php`
- WS example: `ws/server.php`

## Hardening
- Serve over HTTPS.
- Protect agent/admin UIs with login.
- Add MIME/size checks to uploads and optional scanning.
- Add rate limits to `start.php` and CAPTCHA to prevent spam.
