<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/auth.php';
$claims = require_auth(['admin']);
$pdo = db();
$stats = [];
$stats['conversations_today'] = (int)$pdo->query("SELECT COUNT(*) c FROM conversations WHERE DATE(created_at)=CURDATE()")->fetch()['c'];
$stats['avg_first_response_sec'] = (int)$pdo->query("
  SELECT IFNULL(AVG(TIMESTAMPDIFF(SECOND, c.created_at, m.first_agent_ts)),0) as avg_sec
  FROM (
    SELECT conversation_id, MIN(created_at) first_agent_ts
    FROM messages WHERE sender_type='agent' GROUP BY conversation_id
  ) m
  JOIN conversations c ON c.id=m.conversation_id
")->fetch()['avg_sec'];
$stats['csat'] = (float)$pdo->query("SELECT IFNULL(AVG(score),0) avg_score FROM ratings")->fetch()['avg_score'];
json_response(['stats'=>$stats]);
?>