<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../lib/auth.php';
$data = require_json();
$email = trim($data['email'] ?? '');
$password = (string)($data['password'] ?? '');
$pdo = db();
$stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND is_active=1"); $stmt->execute([$email]);
$user = $stmt->fetch();
if (!$user || !password_verify($password, $user['password_hash'])) json_response(['error'=>'Invalid credentials'], 401);
$pdo->prepare("UPDATE users SET last_login=NOW() WHERE id=?")->execute([$user['id']]);
$jwt = create_jwt($user);
json_response(['token'=>$jwt, 'user'=>['id'=>$user['id'],'email'=>$user['email'],'name'=>$user['name'],'role'=>$user['role']]]);
?>