<?php
require_once __DIR__ . '/../config.php';
function fire_webhooks($event, $payload){
  $pdo = db();
  $stmt = $pdo->prepare("SELECT * FROM webhooks WHERE event=? AND is_active=1");
  $stmt->execute([$event]);
  foreach ($stmt as $hook){
    $sig = hash_hmac('sha256', json_encode($payload), $hook['secret']);
    $ch = curl_init($hook['url']);
    curl_setopt_array($ch, [
      CURLOPT_POST=>1,
      CURLOPT_POSTFIELDS=>json_encode(['event'=>$event,'data'=>$payload]),
      CURLOPT_HTTPHEADER=>['Content-Type: application/json','X-Signature: '.$sig],
      CURLOPT_RETURNTRANSFER=>true, CURLOPT_TIMEOUT=>2
    ]);
    curl_exec($ch); curl_close($ch);
  }
}
?>