<?php
require_once __DIR__ . '/../config.php';
function password_hash_strong($password) { return password_hash($password, PASSWORD_DEFAULT); }
function create_jwt($user) {
  $header = base64_encode(json_encode(['alg'=>'HS256','typ'=>'JWT']));
  $payload = base64_encode(json_encode(['sub'=>$user['id'],'email'=>$user['email'],'role'=>$user['role'],'exp'=>time()+3600*12]));
  $sig = base64_encode(hash_hmac('sha256', "$header.$payload", APP_SECRET, true));
  return "$header.$payload.$sig";
}
function verify_jwt($jwt) {
  $parts = explode('.', $jwt ?? ''); if (count($parts)!==3) return false;
  list($h,$p,$s) = $parts; $expected = base64_encode(hash_hmac('sha256', "$h.$p", APP_SECRET, true));
  if (!hash_equals($expected, $s)) return false;
  $payload = json_decode(base64_decode($p), true); if (!$payload || ($payload['exp']??0) < time()) return false;
  return $payload;
}
function require_auth($roles = []){
  $hdr = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  if (!preg_match('/Bearer\s+(.+)/i', $hdr, $m)) json_response(['error'=>'Unauthorized'], 401);
  $claims = verify_jwt($m[1]); if (!$claims) json_response(['error'=>'Unauthorized'], 401);
  if ($roles && !in_array($claims['role'], $roles)) json_response(['error'=>'Forbidden'], 403);
  return $claims;
}
?>