<?php
use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;
require __DIR__ . '/vendor/autoload.php';
class ChatServer implements MessageComponentInterface {
  protected $clients; public function __construct(){ $this->clients = new \SplObjectStorage; }
  public function onOpen(ConnectionInterface $conn){ $this->clients->attach($conn); }
  public function onMessage(ConnectionInterface $from, $msg){ foreach ($this->clients as $client){ if ($from !== $client) $client->send($msg); } }
  public function onClose(ConnectionInterface $conn){ $this->clients->detach($conn); }
  public function onError(ConnectionInterface $conn, \Exception $e){ $conn->close(); }
}
$port=8081;
$server = Ratchet\Server\IoServer::factory(new Ratchet\Http\HttpServer(new Ratchet\WebSocket\WsServer(new ChatServer())), $port);
echo "WS listening on :$port\n"; $server->run();
?>